<!DOCTYPE html>
<html>
<head>
    <title>Teste do Formulário - Precificação Flexível</title>
    <meta charset="utf-8">
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .form-section { border: 1px solid #ccc; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .form-section h2 { margin-top: 0; color: #333; }
        .form-section.active { border-color: #007bff; background-color: #f8f9fa; }
        .form-section.inactive { opacity: 0.6; }
        .info { background-color: #d1ecf1; border: 1px solid #bee5eb; padding: 10px; border-radius: 5px; margin: 10px 0; }
        select, input { padding: 5px; margin: 5px; }
        button { background-color: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        button:hover { background-color: #0056b3; }
        .departments-count { background-color: #28a745; color: white; padding: 5px 10px; border-radius: 3px; margin-left: 10px; }
    </style>
</head>
<body>
    <h1>Teste do Formulário de Orçamento - Precificação Flexível</h1>
    
    <div class="info">
        <strong>ℹ️ Informação:</strong> Você pode precificar qualquer combinação de departamentos:
        <ul>
            <li>✅ Apenas Contabilidade</li>
            <li>✅ Apenas Fiscal</li>
            <li>✅ Apenas Departamento Pessoal</li>
            <li>✅ Contabilidade + Fiscal</li>
            <li>✅ Contabilidade + DP</li>
            <li>✅ Fiscal + DP</li>
            <li>✅ Todos os três departamentos</li>
        </ul>
        <span id="departments-count" class="departments-count">Departamentos: 0</span>
    </div>
    
    <form method="post" action="novo_processa.php">
        
        <div class="form-section" id="contabil-section">
            <h2>📊 Contabilidade</h2>
            <p>
                <label>Regime de Tributação:</label>
                <select name="tributoEscolhido_contabil">
                    <option value="">Selecione...</option>
                    <option value="Simples">Simples Nacional</option>
                    <option value="Real">Lucro Real</option>
                    <option value="Presumido">Lucro Presumido</option>
                    <option value="Imune">Imune/Isenta</option>
                    <option value="mei">MEI</option>
                    <option value="rural">Produtor Rural</option>
                    <option value="lucro_real">Carne Leão/Livro Caixa</option>
                </select>
            </p>
            
            <p>
                <label>Atividade:</label>
                <select name="atividadeEscolhida_contabil">
                    <option value="">Selecione...</option>
                    <option value="servico">Serviço</option>
                    <option value="comercio">Comércio</option>
                    <option value="industria">Indústrias</option>
                </select>
            </p>
            
            <p>
                <label>Faturamento:</label>
                <select name="faturamentoEscolhido_contabil">
                    <option value="">Selecione...</option>
                    <option value="0 a 10 MIL">0 a 10 MIL</option>
                    <option value="10 a 20 MIL">10 a 20 MIL</option>
                    <option value="50 a 100 MIL">50 a 100 MIL</option>
                </select>
            </p>
            
            <p>
                <label>Prazo de Entrega:</label>
                <select name="prazodeentrega_contabilescolhido">
                    <option value="">Selecione...</option>
                    <option value="Mensal">Mensal</option>
                    <option value="Trimestral">Trimestral</option>
                    <option value="Semestral">Semestral</option>
                </select>
            </p>
            
            <p>
                <label>Atendimento Back Office:</label>
                <select name="atendimento_cliEscolhido_contabil">
                    <option value="">Selecione...</option>
                    <option value="1">SIM</option>
                    <option value="2">NÃO</option>
                </select>
            </p>
            
            <p>
                <label>Dashboard BI:</label>
                <select name="dashboardBIEscolhido_contabil">
                    <option value="">Selecione...</option>
                    <option value="1">SIM</option>
                    <option value="2">NÃO</option>
                </select>
            </p>
        </div>
        
        <div class="form-section" id="fiscal-section">
            <h2>💰 Fiscal</h2>
            <p>
                <label>Regime de Tributação:</label>
                <select name="tributoEscolhido_tribut">
                    <option value="">Selecione...</option>
                    <option value="Simples">Simples Nacional</option>
                    <option value="Real">Lucro Real</option>
                    <option value="Presumido">Lucro Presumido</option>
                    <option value="mei">MEI</option>
                    <option value="rural">Produtor Rural</option>
                </select>
            </p>
            
            <p>
                <label>Atividade:</label>
                <select name="atividadeEscolhida_trib">
                    <option value="">Selecione...</option>
                    <option value="servico">Serviço</option>
                    <option value="comercio">Comércio</option>
                    <option value="industria">Indústrias</option>
                </select>
            </p>
            
            <p>
                <label>Faturamento:</label>
                <select name="faturamentoEscolhido_trib">
                    <option value="">Selecione...</option>
                    <option value="0 a 10 MIL">0 a 10 MIL</option>
                    <option value="10 a 20 MIL">10 a 20 MIL</option>
                    <option value="50 a 100 MIL">50 a 100 MIL</option>
                </select>
            </p>
            
            <p>
                <label>Compra e Venda Fora do Estado:</label>
                <select name="compraeVendaForaEscolhido">
                    <option value="">Selecione...</option>
                    <option value="sim">SIM</option>
                    <option value="não">NÃO</option>
                </select>
            </p>
            
            <p>
                <label>Atendimento Cliente:</label>
                <select name="atendimento_cliente_tribut">
                    <option value="">Selecione...</option>
                    <option value="1">SIM</option>
                    <option value="2">NÃO</option>
                </select>
            </p>
            
            <p>
                <label>Fator R:</label>
                <select name="fatorR_escolhido">
                    <option value="">Selecione...</option>
                    <option value="1">SIM</option>
                    <option value="2">NÃO</option>
                </select>
            </p>
        </div>
        
        <div class="form-section" id="dp-section">
            <h2>👥 Departamento Pessoal</h2>
            <p>
                <label>Modalidade da Folha:</label>
                <select name="modalidade_folhaEscolhido">
                    <option value="">Selecione...</option>
                    <option value="Sem Movimento">Sem Movimento</option>
                    <option value="Eventos Fixos">Eventos Fixos</option>
                    <option value="Eventos Variáveis">Eventos Variáveis</option>
                    <option value="Horista">Horista</option>
                </select>
            </p>
            
            <p>
                <label>Quantidade de Funcionários:</label>
                <select name="qtd_funcionarioEscolhido">
                    <option value="">Selecione...</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="5">5</option>
                    <option value="10">10</option>
                </select>
            </p>
            
            <p>
                <label>Atendimento Backoffice:</label>
                <select name="atendimento_backofficeEscolhido">
                    <option value="">Selecione...</option>
                    <option value="1">SIM</option>
                    <option value="2">NÃO</option>
                </select>
            </p>
        </div>
        
        <input type="submit" value="Calcular Orçamento">
    </form>

    <script>
        // JavaScript para destacar seção ativa e contar departamentos
        function updateDepartmentsCount() {
            let count = 0;
            
            // Verificar Contabilidade
            if (document.querySelector('select[name="tributoEscolhido_contabil"]').value) {
                count++;
            }
            
            // Verificar Fiscal
            if (document.querySelector('select[name="tributoEscolhido_tribut"]').value) {
                count++;
            }
            
            // Verificar DP
            if (document.querySelector('select[name="modalidade_folhaEscolhido"]').value) {
                count++;
            }
            
            document.getElementById('departments-count').textContent = `Departamentos: ${count}`;
        }

        document.querySelectorAll('select').forEach(select => {
            select.addEventListener('change', function() {
                const section = this.closest('.form-section');
                if (this.value) {
                    section.classList.add('active');
                } else {
                    section.classList.remove('active');
                }
                updateDepartmentsCount();
            });
        });

        // Inicializar contador
        updateDepartmentsCount();
    </script>
</body>
</html>
